/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.client.renderer.entity;

import com.t2pellet.strawgolem.StrawgolemCommon;
import com.t2pellet.strawgolem.client.renderer.entity.model.ModelStrawGolem;
import com.t2pellet.strawgolem.config.StrawgolemConfig;
import com.t2pellet.strawgolem.entity.EntityStrawGolem;
import com.t2pellet.strawgolem.registry.ClientRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_927;
import net.minecraft.class_989;

public class RenderStrawGolem
extends class_927<EntityStrawGolem, ModelStrawGolem> {
    private static final Map<String, class_2960> TEXTURE_MAP;
    private static final class_2960 TEXTURE_DEFAULT;
    private static final class_2960 TEXTURE_OLD;
    private static final class_2960 TEXTURE_DYING;
    private static final class_2960 TEXTURE_WINTER;
    private static final boolean IS_DECEMBER;

    public RenderStrawGolem(class_5617.class_5618 context) {
        super(context, (class_583)new ModelStrawGolem(context.method_32167(ClientRegistry.Entities.getStrawGolemModel())), 0.35f);
        this.method_4046((class_3887)new class_989((class_3883)this));
    }

    public void render(EntityStrawGolem mobEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
        ((ModelStrawGolem)this.method_4038()).setHoldingBlock(mobEntity.holdingFullBlock());
        ((ModelStrawGolem)this.method_4038()).setHoldingItem(!mobEntity.isHandEmpty());
        ((ModelStrawGolem)this.method_4038()).setHungry(mobEntity.getHunger().isHungry());
        ((ModelStrawGolem)this.method_4038()).setTempted(mobEntity.isTempted());
        if (mobEntity.getHunger().isHungry()) {
            matrixStack.method_22904(0.0, (double)-0.2f, 0.0);
        }
        if (StrawgolemConfig.Miscellaneous.isShiverEnabled() && (mobEntity.isInCold() || mobEntity.method_5637())) {
            double offX = mobEntity.method_6051().nextDouble() / 32.0 - 0.015625;
            double offZ = mobEntity.method_6051().nextDouble() / 32.0 - 0.015625;
            matrixStack.method_22904(offX, 0.0, offZ);
        }
        super.method_4072((class_1308)mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    public class_2960 getTextureLocation(EntityStrawGolem golem) {
        String name;
        int maxLifespan;
        int lifespan = golem.getLifespan().get();
        if (lifespan * 4 < (maxLifespan = StrawgolemConfig.Health.getLifespan()) && lifespan >= 0) {
            return TEXTURE_DYING;
        }
        if (golem.method_16914() && TEXTURE_MAP.containsKey(name = golem.method_5476().getString().toLowerCase())) {
            return TEXTURE_MAP.get(name);
        }
        if (IS_DECEMBER) {
            return TEXTURE_WINTER;
        }
        if (lifespan < 0) {
            return TEXTURE_DEFAULT;
        }
        return lifespan * 2 < maxLifespan ? TEXTURE_OLD : TEXTURE_DEFAULT;
    }

    protected void renderNameTag(EntityStrawGolem entity, class_2561 text, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (!entity.method_16914() || !TEXTURE_MAP.containsKey(entity.method_5476().getString().toLowerCase())) {
            super.method_3926((class_1297)entity, text, matrices, vertexConsumers, light);
        }
    }

    static {
        TEXTURE_DEFAULT = new class_2960("strawgolem", "textures/entity/golem.png");
        TEXTURE_OLD = new class_2960("strawgolem", "textures/entity/old_golem.png");
        TEXTURE_DYING = new class_2960("strawgolem", "textures/entity/dying_golem.png");
        TEXTURE_WINTER = new class_2960("strawgolem", "textures/entity/winter_golem.png");
        TEXTURE_MAP = new HashMap<String, class_2960>();
        InputStream nameStream = StrawgolemCommon.class.getResourceAsStream("/assets/strawgolem/textures/entity/customnames");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(nameStream, StandardCharsets.UTF_8));
            while (reader.ready()) {
                String name = reader.readLine();
                class_2960 loc = new class_2960("strawgolem", "textures/entity/" + name + ".png");
                TEXTURE_MAP.put(name, loc);
            }
            reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        IS_DECEMBER = GregorianCalendar.getInstance().get(2) == 11;
    }
}

